@extends('admin.layout.master')

@section('body')
         <div class="card">


             <div class="card-header bg-white font-weight-bold">
                 <h4>{{$page_title}}</h4>
             </div>
                <div class="card-body">
                    <div class="table-responsive">
                        <table class="table table-striped table-bordered table-hover">
                            <thead>
                            <tr>
                                <th> SL </th>
                                <th> Username </th>
                                <th> Customer Email </th>
                                <th>  Method Name	 </th>
                                <th> User Wallet Info	  </th>
                                <th> User Receive  </th>
                                <th> Withdraw Amount  </th>
                                <th> Status </th>
                            </tr>
                            </thead>
                            <tbody>
                            @foreach($withdrawLog as $k=>$data)
                                <tr>
                                    <td>{{++$k}}</td>
                                    <td>
                                        <a href="{{route('user.single',$data->user->id)}}"> {{$data->user->username}}</a>
                                    </td>
                                    <td>{{$data->user_email}}</td>

                                    <td> <strong>{!! ($data->method->name) ?? '' !!}</strong></td>
                                    <td> {!! $data->user_wallet_info !!}</td>

                                    <td> <strong>{{number_format($data->receive_currency_amount, $basic->decimal) }}  {{  ($data->method->name) ??  $basic->currency}} </strong></td>
                                    <td> <strong>{{number_format($data->withdraw_amount, $basic->decimal)}}   {{$basic->currency}} </strong></td>
                                    <td>
                                        @if($data->status == 2)
                                            <span  class="badge  badge-pill  badge-success "> Approved </span>
                                        @elseif($data->status == 1)
                                            <span class="badge  badge-pill  badge-warning ">Pending </span>
                                        @elseif($data->status == -2)
                                            <span class="badge  badge-pill  badge-danger ">Refund </span>
                                        @endif
                                    </td>
                                </tr>




                            @endforeach
                            <tbody>
                        </table>

                        {!!  $withdrawLog->links()!!}
                    </div>
                </div>
            </div>


@endsection